/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import filenet.pe.peorb.client.SyncVersion;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;

public class ClientInfoUtilities {
    protected static String G_CE_BUILD_VERSION = null;
    protected static String G_HOST_ADDRESS = null;
    protected static String G_CLIENT_INFO = null;
    protected static String G_IDL_VERSION = null;
    protected static String G_JVM_PROPERTIES = null;
    protected static String G_JVM_VERSION = null;
    protected static String G_JVM_LIBRARY_PATH = null;
    private static String CLIENT_INFO = null;

    private static void getIDLVersion() {
        int j;
        int i;
        String VERSION2 = ClientInfoUtilities.getPERPC_VERSION();
        int len = VERSION2 == null ? 0 : VERSION2.length();
        for (i = 0; i < len && !Character.isDigit(VERSION2.charAt(i)); ++i) {
        }
        for (j = i; j < len && (Character.isDigit(VERSION2.charAt(j)) || VERSION2.charAt(j) == '.'); ++j) {
        }
        G_IDL_VERSION = VERSION2.substring(i, j);
    }

    private static void getClientName() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress localHost = InetAddress.getLocalHost();
                    G_HOST_ADDRESS = localHost.getHostAddress() + ":" + localHost.getHostName();
                    G_CLIENT_INFO = G_IDL_VERSION + ":" + G_HOST_ADDRESS;
                }
                catch (Exception e) {
                    G_CLIENT_INFO = G_IDL_VERSION + "::localhost";
                }
                return null;
            }
        });
    }

    private static void getJVMSystemProperties() {
        Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        if (sysProps == null) {
            return;
        }
        Enumeration<Object> keys = sysProps.keys();
        StringBuffer buf = new StringBuffer();
        buf.append("<p><h2>System properties</h2></p><p>");
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buf.append("<li>").append(key).append("=").append(sysProps.get(key));
        }
        buf.append("</p>");
        G_JVM_PROPERTIES = buf.toString();
        G_JVM_VERSION = sysProps.getProperty("java.runtime.version");
        G_JVM_LIBRARY_PATH = sysProps.getProperty("java.library.path");
        if (G_JVM_LIBRARY_PATH != null) {
            String[] paths = G_JVM_LIBRARY_PATH.split(File.pathSeparator);
            G_JVM_LIBRARY_PATH = paths[0];
        }
    }

    private static void getJaceVersion() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run() {
                InputStream inStream = null;
                Class<?> factoryClass = Class.forName("com.filenet.api.core.Factory");
                URL jarURL = factoryClass.getResource("/com/filenet/apiimpl/util/FileNetBuild.properties");
                URLConnection obj = jarURL.openConnection();
                inStream = obj.getInputStream();
                Properties props = new Properties();
                props.load(inStream);
                G_CE_BUILD_VERSION = props.getProperty("BuildVersion");
                Object var7_7 = null;
                if (inStream == null) return null;
                try {
                    inStream.close();
                    return null;
                }
                catch (Exception e2) {}
                return null;
                {
                    catch (Throwable e) {
                        G_CE_BUILD_VERSION = "dap000.xxx";
                        Object var7_8 = null;
                        if (inStream == null) return null;
                        try {
                            inStream.close();
                            return null;
                        }
                        catch (Exception e2) {}
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (inStream == null) throw throwable;
                    try {
                        inStream.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        });
    }

    private static String getPERPC_VERSION() {
        try {
            Class<?> aClass = Class.forName("filenet.pe.peorb.FileNet_PERPC.VERSION");
            Field aField = aClass.getField("value");
            return (String)aField.get(null);
        }
        catch (Throwable t) {
            return "INVALID VWBuildStamp.buildLine";
        }
    }

    private static String getVWBuildStamp_BuildLine() {
        try {
            Class<?> aClass = Class.forName("filenet.vw.toolkit.utils.VWBuildStamp");
            Field aField = aClass.getField("buildLine");
            return (String)aField.get(null);
        }
        catch (Throwable t) {
            return "INVALID VWBuildStamp.buildLine";
        }
    }

    public static String GetClientInfo() {
        if (CLIENT_INFO == null) {
            ClientInfoUtilities.getJaceVersion();
            ClientInfoUtilities.getIDLVersion();
            ClientInfoUtilities.getClientName();
            ClientInfoUtilities.getJVMSystemProperties();
            StringBuffer buf = new StringBuffer("<p>**** SYSTEM INFO ****\n");
            buf.append(G_HOST_ADDRESS).append("\n").append("VWBuildStamp.buildLine=").append(ClientInfoUtilities.getVWBuildStamp_BuildLine()).append("\n").append("PE API IDL Version=").append(G_IDL_VERSION).append("\n").append("CEAPI=").append(G_CE_BUILD_VERSION).append("\n</p>").append(G_JVM_PROPERTIES);
            CLIENT_INFO = buf.toString();
        }
        return CLIENT_INFO;
    }

    public static String[] GetRPCTimingInfo() {
        return SyncVersion.getPERPCStats();
    }

    public static void AppendRPCTimingInfo(StringBuffer rBuf) {
        int nItems;
        if (rBuf == null) {
            return;
        }
        String[] res = SyncVersion.getPERPCStats();
        int n = nItems = res == null ? 0 : res.length;
        if (nItems > 0) {
            rBuf.append("\n------------------------------\nPE API RPC Timing:\n------------------------------\n");
            rBuf.append("name;nTimes;worstTime;whenWorstTime;bestTime;whenBestTime;avgTime;totalTime\n");
            for (int i = 0; i < nItems; ++i) {
                if (res[i] == null) continue;
                rBuf.append(res[i]);
            }
            rBuf.append("------------------------------\n");
        }
    }

    public static void ResetRPCTimingInfo() {
        SyncVersion.resetPERPCStats();
    }

    public static void PrintRPCTimingInfoAsHTML(PrintWriter out) {
        out.println("<table border=\"1\" bgcolor=\"#8080c0\">");
        out.println("\t<caption align=\"top\"><font color=\"#000000\"><p><h2>PEAPI-PEServer RPC Timing info</h2></p></font></caption>");
        out.println("\t<tbody>");
        out.println("\t\t<tr>");
        out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Method</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">NTimes</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">Worst</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">When</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">Best</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">When</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">Avg</font></td>\t\t\t<td align=\"right\"><font color=\"#000000\">Total</font></td>");
        out.println("\t\t</tr>");
        String[] res = ClientInfoUtilities.GetRPCTimingInfo();
        int nItems = res == null ? 0 : res.length;
        for (int i = 0; i < nItems; ++i) {
            int nValues;
            if (res[i] == null) continue;
            String[] values = res[i].split(";");
            int n = nValues = values == null ? 0 : values.length;
            if (nValues < 8) continue;
            out.println("\t\t<tr>\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[0] + "</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[1] + "</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[2] + "ms</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[3] + "</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[4] + "ms</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[5] + "</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[6] + "ms</font></td>" + "\n\t\t\t<td align=\"right\"><font color=\"#000000\">" + values[7] + "sec</font></td>" + "\t\t</tr>");
        }
        out.println("\t</tbody>");
        out.println("</table>");
    }

    public static void main(String[] args) {
        System.out.println(ClientInfoUtilities.GetClientInfo());
    }

    static {
        ClientInfoUtilities.GetClientInfo();
    }
}

